// UPhoneMatch.cp
// UPhoneMatch.h
// ----------------------------------------------------------------------------------
// Phonetic matcher for the Spell Checker project.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// This matches two phonemes.  You have the character position of a phoneme
// in a string and then the number of the phoneme.  ie. is it the first
// phoneme, or the second one in the string.  In other words the class 
// converts a string into a 'phonetical string' rather than a character
// string.  This is then compared.
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/13/94
//			Fixed it up slightly.  Nothing major
// ----------------------------------------------------------------------------------




#include "UPhnMch.h"
#include <string.h>

#define bitset(buf,bit) (buf[(bit) >> 3] |= (1 << ((bit) & 7)))
#define bitget(buf,bit) (((buf[(bit) >> 3] >> ((bit) & 7 )) & 1 ))

// ----------------------------------------------------------------------------------
//	UPhoneMatch		- Constructor
// ----------------------------------------------------------------------------------
// The constructor sets up the values for the phonemes

UPhoneMatch::UPhoneMatch()
{
	WordFilter = &WordFilterBuffer[0];
	memset(WordFilter,0,128);
	P_B =1; P_CH =2; P_D = 3; P_F = 4; P_G = 5; P_H = 6; P_J = 7; P_K = 8;
	P_L =9; P_L = 10; P_M = 11; P_N = 12; P_P = 13; P_R = 14; P_S = 15;
	P_SH = 16; P_T = 17; P_TS = 18; P_V = 19; P_W = 20; P_Z = 21; P_VWL = 22;
	P_Ve = 23; P_Vet = 24; P_EOW = 25;
}


// ----------------------------------------------------------------------------------
//	Insert		- Inserts a bit into the filter representing the word
// ----------------------------------------------------------------------------------
//


inline long
UPhoneMatch::Hash(long Num1, long Num2)
{
	return (((Num1-1) * 32) + Num2-1);
}


void
UPhoneMatch::Insert( short Phoneme, short  Position)
{
	short Result;

	Result = Hash(Phoneme,Position);
	bitset(WordFilter,Result);
}


// ----------------------------------------------------------------------------------
//	Check		- checks to see if the phoneme is in the filter
// ----------------------------------------------------------------------------------
//


short  UPhoneMatch :: Check(short  Phoneme, short  Position)
{
	short Result;
	
	Result = Hash(Phoneme,Position);
	if ( bitget( WordFilter, Result ) == 0)
		return NOTFOUND;
	return FOUND;
}

// ----------------------------------------------------------------------------------
//	Reset		- resets the filter
// ----------------------------------------------------------------------------------
// This resets the filter so that a whole new batch of phonemes can be entered
// and tested.

void
UPhoneMatch::Reset()
{
	memset( WordFilter, 0, (WORDFILTERSIZE) );
}

// ----------------------------------------------------------------------------------
//	Hash		- Hash storage
// ----------------------------------------------------------------------------------
// This is a hashing function given two numbers and array size.  For us we've
// hard coded it as 32.






